package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;

public class VerticalBlockScreenObject extends MobileScreenObject implements CloneableScreenObject {

	private boolean shouldBePassthru;
	private IntRect clickRect;
	private boolean isSelected;
	
	private VerticalBlockScreenPaletteObject paletteObject;
	
	
	
	public VerticalBlockScreenObject(int x, int y, int width, int height, VerticalBlockScreenPaletteObject thePaletteObject, boolean passThru, int theSpeed) {
		
		paletteObject = thePaletteObject;
		
		clickRect = new IntRect(x - width/2, y - height/2, width, height);
		isSelected = false;
		shouldBePassthru = passThru;
		setSpeed(theSpeed);
		
		this.setVertical(true);
		
		this.setMin(y);
		this.setMax(y);
		
	}
	
	
	
	@Override
	public void draw(Graphics g) {
		if(paletteObject.getImage() != null) {
			
			Point center = clickRect.getCenter();
			
			Color origColor = g.getColor();
			
			g.setColor(new Color(0, 0, 255));
			g.drawLine(center.x - 5, center.y, center.x - 5, this.getMin());
			g.drawLine(center.x + 5, center.y, center.x + 5, this.getMin());
			
			g.setColor(new Color(0, 51, 255));
			g.drawLine(center.x - 4, center.y, center.x - 4, this.getMin());
			g.drawLine(center.x + 4, center.y, center.x + 4, this.getMin());
			
			g.setColor(new Color(0, 102, 255));
			g.drawLine(center.x - 3, center.y, center.x - 3, this.getMin());
			g.drawLine(center.x + 3, center.y, center.x + 3, this.getMin());
			
			g.setColor(new Color(0, 153, 255));
			g.drawLine(center.x - 2, center.y, center.x - 2, this.getMin());
			g.drawLine(center.x + 2, center.y, center.x + 2, this.getMin());
			
			g.setColor(new Color(0, 204, 255));
			g.drawLine(center.x - 1, center.y, center.x - 1, this.getMin());
			g.drawLine(center.x + 1, center.y, center.x + 1, this.getMin());
			
			g.setColor(new Color(0, 255, 255));
			g.drawLine(center.x, center.y, center.x, this.getMin());
			g.drawLine(center.x + 10, this.getMin(), center.x - 10, this.getMin());
			
			
			
			
			g.setColor(new Color(255, 0, 0));
			g.drawLine(center.x - 5, center.y, center.x - 5, this.getMax());
			g.drawLine(center.x + 5, center.y, center.x + 5, this.getMax());
			
			g.setColor(new Color(255, 51, 0));
			g.drawLine(center.x - 4, center.y, center.x - 4, this.getMax());
			g.drawLine(center.x + 4, center.y, center.x + 4, this.getMax());
			
			g.setColor(new Color(255, 102, 0));
			g.drawLine(center.x - 3, center.y, center.x - 3, this.getMax());
			g.drawLine(center.x + 3, center.y, center.x + 3, this.getMax());
			
			g.setColor(new Color(255, 153, 0));
			g.drawLine(center.x - 2, center.y, center.x - 2, this.getMax());
			g.drawLine(center.x + 2, center.y, center.x + 2, this.getMax());
			
			g.setColor(new Color(255, 204, 0));
			g.drawLine(center.x - 1, center.y, center.x - 1, this.getMax());
			g.drawLine(center.x + 1, center.y, center.x + 1, this.getMax());
			
			g.setColor(new Color(255, 255, 0));
			g.drawLine(center.x, center.y, center.x, this.getMax());
			g.drawLine(center.x + 10, this.getMax(), center.x - 10, this.getMax());
			
			
			
			g.setColor(origColor);
			
			paletteObject.getImage().drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		}
		
		drawInitialDirIndicator(g);
		
		if(isSelected)
			drawSelectionOverObject(g);
		
		
		
		
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		return isSelected;
	}


	
	
	public boolean shouldBePassThru() {
		return shouldBePassthru;
	}
	
	public void setShouldBePassThru(boolean should) {
		shouldBePassthru = should;
	}



	@Override
	public void setClickRect(IntRect newRect) {
		clickRect = newRect;
	}
	
	
	
	public void writeOutToFile(BufferedWriter out) throws Exception{
		
		out.write("movingBlock:");
		out.newLine();
		
		Point centerPoint = clickRect.getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();
		
		out.write("width:");
		out.write(Integer.toString(this.getClickRect().width()));
		out.newLine();
		
		out.write("height:");
		out.write(Integer.toString(this.getClickRect().height()));
		out.newLine();
		
		out.write("graphic:");
		out.write(this.paletteObject.getImage().getFileName());
		out.newLine();
		
		if(this.paletteObject.shouldBePassThru()) {
			out.write("passThru");
		} else {
			out.write("solid");
		}
		out.newLine();
		
		out.write("transparent:");
		out.write(CustomAnimationPanel.convertColorToString(paletteObject.getImage().getTransparentColor()));
		out.newLine();
		
		out.write("dir:");
		if(this.isGoingMinDirection()) {
			out.write("u");
		} else {
			out.write("d");
		}
		out.newLine();
		
		out.write("minY:");
		out.write(Integer.toString(this.getMin()));
		out.newLine();
		
		out.write("maxY:");
		out.write(Integer.toString(this.getMax()));
		out.newLine();
		
		out.write("vertical");
		out.newLine();
		
		out.write("speed:");
		out.write(Integer.toString(this.getSpeed()));
		out.newLine();

		out.write("defaultSpeed:");
		out.write(Integer.toString(this.paletteObject.getDefaultSpeed()));
		out.newLine();
		
		out.write("/movingBlock");
		out.newLine();
		
		out.newLine();
	}

	
	public VerticalBlockScreenObject clone(ImageObserver io) {
		
		Point centerPoint = clickRect.getCenter();
		
		VerticalBlockScreenObject returnValue = new VerticalBlockScreenObject(centerPoint.x, centerPoint.y, clickRect.width(), clickRect.height(), this.paletteObject, this.paletteObject.shouldBePassThru(), this.getSpeed());
		returnValue.setMax(this.getMax());
		returnValue.setMin(this.getMin());
		returnValue.setGoingMinDirection(this.isGoingMinDirection());
		
		return returnValue;
		
		
	}
	
	@Override
	public int getLayer() {
		
		return 7;
	}

}
